#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.DAL.UnitTests
{
	[TestFixture]
	public class DAL_VbecsVersion : BaseTest 
	{
		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			//Clear out all records
			UnitTestUtil.RunSQL("DELETE FROM VbecsVersion");
		}

		[Test]
		public void GetVbecsVersion_Pass()
		{
			//By default, UnitTests kill VbecsVersion, so we put one in there, plus I kill it in SetUp now
			string randomNumber  = DateTime.Now.Ticks.ToString();
			UnitTestUtil.RunSQL("INSERT INTO VbecsVersion (Version, PatchSuccessfulIndicator, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES ('" + randomNumber + "', 1, GETUTCDATE(), '" + Common.LogonUser.LogonUserName + "', 9999)"); 

			DataTable tstValue = DAL.VbecsVersion.GetVbecsVersion();
			Assert.AreEqual(1, tstValue.Rows.Count, "Manual Record");
		}

		[Test]
		public void GetVbecsVersion_Fail()
		{
			UnitTestUtil.RunSQL("DELETE FROM VbecsVersion");

			DataTable tstValue = DAL.VbecsVersion.GetVbecsVersion();
			Assert.AreEqual(0, tstValue.Rows.Count, "No Records");
		}

	}
}

#endif
